DROP FUNCTION IF EXISTS ab2__a_i__resource_requirement_options__ksvba__create() CASCADE;
CREATE OR REPLACE FUNCTION ab2__a_i__resource_requirement_options__ksvba__create()
  RETURNS TRIGGER AS $$

  DECLARE

      _prefix varchar := 'TRIGGER ab2__a_i__resource_requirement_options__ksvba__create -';
      _loglevel integer := TSystem.Log_Get_LogLevel( _user => 'yes' );

  BEGIN

      -- Debug
      IF _loglevel >= 4 THEN
          RAISE NOTICE '% a2_id:%;', _prefix, new.a2_id;
      END IF;

      -- AG-Ressource anlegen.
      INSERT INTO scheduling.resource( context, context_id )
           VALUES                    ( 'ab2'  , new.a2_id  );
      -- Mit dem AG verknüpftes Ressourcen-Netzwerk aufbauen.
      PERFORM scheduling.ab2__resource_requirements_options__ksvba__from__ab2__create( new, _loglevel => _loglevel );

      RETURN new;

  END $$ LANGUAGE plpgsql;
  --
  DROP TRIGGER IF EXISTS ab2__a_i__resource_requirement_options__ksvba__create ON ab2;
  CREATE TRIGGER ab2__a_i__resource_requirement_options__ksvba__create
    AFTER INSERT
    ON ab2
    FOR EACH ROW
    EXECUTE PROCEDURE ab2__a_i__resource_requirement_options__ksvba__create();
